clc
clear
close all

disp("Data loading...")

name = {'elev', 'srad', 'tavg', 'tmax', 'tmin', 'vapr', 'wind'}; % print the name of the folder
folder = cellfun(@(p) addpath(strrep("wc2.1_30s_%PARAM%", "%PARAM%", p)), name, 'UniformOutput', false);

months = sprintfc('%02d', 12); % print the # of months
c = 43200/2;

% elevation
[elev, ref] = readgeoraster("wc2.1_30s_elev\wc2.1_30s_elev.tif");
elev = single(elev);
elev(elev == (min(elev, [], "all"))) = NaN;

disp("Elevation")

% average temperature
Tavg = readgeoraster(strrep("wc2.1_30s_tavg\wc2.1_30s_tavg_%m%.tif", "%m%", months));
Tavg(Tavg == (min(Tavg, [], "all"))) = NaN;

disp("Average temperature")
%%

% Group 1
% elev = elev(:, 1:c);
% Tavg = Tavg(:, 1:c);

% Group 2
elev = elev(:, c+1:end);
Tavg = Tavg(:, c+1:end);


% pressure that varies with any possible altitude, measured in [kPa]
p = 101.325 * ((293 - 0.0065 * elev)/293).^(5.256);

disp("Pressure")

% psychrometric constant, measured in [kPa/°C]
% gamma = p * const / lambda
% lambda = 2.5 - 0.0024 * Tavg

lambda = 2.5 - 0.0024 .* Tavg;

disp("Lambda")
%%
gamma = (p .* 0.000665) ./ lambda;

disp("Gamma")
%%
disp("Saving Gamma...")

save(strrep("gamma2_%m%.mat", "%m%", months), "gamma", "-v7.3");

%% Putting together the two gamma

gamma1 = load(strrep("gamma1_%m%.mat", "%m%", months));
gamma1 = gamma1.gamma;
gamma2 = load(strrep("gamma2_%m%.mat", "%m%", months));
gamma2 = gamma2.gamma;

gamma_tog = [gamma1 gamma2];

disp("Saving Gamma together...")

save(strrep("gamma_%m%.mat", "%m%", months), "gamma_tog", "-v7.3");

